/*:
 * @target MZ
 * @plugindesc メッセージ表示中に指定したSEをインターバルで再生する（スイッチで無効化） v1.0.1
 * @author ChatGPT
 *
 * @param seName
 * @type file
 * @dir audio/se/
 * @text 再生するSE
 * @default Cursor1
 *
 * @param volume
 * @type number
 * @text ボリューム
 * @default 90
 * @min 0
 * @max 100
 *
 * @param interval
 * @type number
 * @text 何文字ごとに鳴らすか
 * @default 2
 * @min 1
 *
 * @param controlSwitch
 * @type switch
 * @text 無効化用スイッチ
 * @default 6
 *
 */

(() => {
    const parameters = PluginManager.parameters("MessageTypeSound");
    const seName = String(parameters["seName"] || "Cursor1");
    const volume = Number(parameters["volume"] || 90);
    const interval = Number(parameters["interval"] || 2);
    const controlSwitch = Number(parameters["controlSwitch"] || 6);

    // メッセージごとにカウントする用
    const _Window_Message_processCharacter =
        Window_Message.prototype.processCharacter;
    Window_Message.prototype.processCharacter = function(textState) {
        _Window_Message_processCharacter.call(this, textState);

        // 🔹 スイッチがOFFのときだけ鳴るように変更
        if (!$gameSwitches.value(controlSwitch)) {
            if (!this._seCharCount) this._seCharCount = 0;
            this._seCharCount++;

            if (this._seCharCount % interval === 0) {
                AudioManager.playSe({
                    name: seName,
                    volume: volume,
                    pitch: 100,
                    pan: 0
                });
            }
        }
    };

    // メッセージ終了時にカウンタをリセット
    const _Window_Message_terminateMessage = Window_Message.prototype.terminateMessage;
    Window_Message.prototype.terminateMessage = function() {
        _Window_Message_terminateMessage.call(this);
        this._seCharCount = 0;
    };
})();
